#region References

using System;
using System.IO;
using System.Text;
using System.Data;
using System.Collections;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages
{
	/// <summary>
	/// New class for BCE (CR 2962)
	/// </summary>
	public sealed class HL7BrpMessage : HL7ProtocolMessage
	{
		#region Variables

		/// <summary>
		/// Response message(BRT) to a Patient Transfusion\Disposition Message(BTS)
		/// </summary>
		private const string MESSAGE_TYPE = "BRP~O30";

		private const bool RESPONSE_REQUIRED_INDICATOR = false;

		private string _errorCode;
		private string _errorText;
		private string _ackCode;
		private string _msh;
		private string _msa;
		private string _err;

		#endregion

		#region Constructors

		/// <summary>
		/// Empty static constructor added to get rid of "beforefieldinit" attribute generated by compiler.
		/// </summary>
		static HL7BrpMessage() {}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8746"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>HL7BrpMessage</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8747"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor to load HL7 Message.
		/// </summary>
		/// <param name="message"></param>
		public HL7BrpMessage( string message )
			: base( message )
		{
			if( message == null )
			{
				throw( new ArgumentNullException( "message" ) );
			}
			//
			_message = message;
			//
			_messageControlID = HL7Utility.GetMessageControlID( message );
			//
			LoadDataFromHL7Message();
		}

		#endregion

		#region Public Methods

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8748"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8749"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Overridden method to get the full hl7 message.
		/// </summary>
		/// <returns></returns>
		public override string GetMessage()
		{
			return Message;
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8752"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8753"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Overridden method to get the Message Control ID
		/// </summary>
		/// <returns></returns>
		public override string GetMessageControlID()
		{
			return MessageControlID;
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8754"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8755"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Overriden method to get the Message Type.
		/// </summary>
		/// <returns></returns>
		public override string GetMessageType()
		{
			return MessageType;
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8750"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8751"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsResponseRequired
		/// </summary>
		/// <returns></returns>
		public override bool IsResponseRequired()
		{
			return RESPONSE_REQUIRED_INDICATOR;
		}

		#endregion

		#region Protected Methods

		/// <summary>
		/// WriteHL7MessageBody
		/// </summary>
		/// <param name="writer"></param>
		protected override void WriteHL7MessageBody( StreamWriter writer )
		{
			if( writer == null )
				throw( new ArgumentNullException( "writer" ) );

			writer.Write( this.Message );
		}


		#endregion

		#region Private Methods

		/// <summary>
		/// LoadDataFromHL7Message
		/// </summary>
		private void LoadDataFromHL7Message()
		{
			_msh = HL7Utility.ParseGetRequiredMessageSegment(this.Message, SegmentTypeNames.MSH);
			_msa = HL7Utility.ParseGetRequiredMessageSegment(this.Message, SegmentTypeNames.MSA);
			_err = HL7Utility.ParseGetOptionalMessageSegment(this.Message, SegmentTypeNames.ERR);

			_ackCode = HL7Utility.ParseGetAckCode( this.Message );
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8766"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8767"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// AcknowledgementCode
		/// </summary>
		public string AcknowledgementCode
		{
			get
			{
				return _ackCode;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/26/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8772"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8773"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ErrorCode
		/// </summary>
		public string ErrorCode
		{
			get
			{
				if ( _errorCode == null )
				{
					string [] errorCodeAndMessage = HL7.OpenLibrary.HL7Utility.ParseGetErrorCodeAndMessage( _message );
					//
					if ( errorCodeAndMessage != null )
					{
						_errorCode = errorCodeAndMessage[0];
						//
						if ( errorCodeAndMessage.Length > 1 )
						{
							_errorText = errorCodeAndMessage[1];
						}
					}
				}
				//
				return _errorCode;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8768"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8769"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ErrorText
		/// </summary>
		public string ErrorText
		{
			get
			{
				if ( _errorText == null )
				{
					string [] errorCodeAndMessage = HL7.OpenLibrary.HL7Utility.ParseGetErrorCodeAndMessage( _message );
					//
					if ( errorCodeAndMessage != null )
					{
						_errorCode = errorCodeAndMessage[0];
						//
						if ( errorCodeAndMessage.Length > 1 )
						{
							_errorText = errorCodeAndMessage[1];
						}
					}
				}
				//
				return _errorText;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8758"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8759"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Message
		/// </summary>
		public string Message
		{
			get
			{
				return _message;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8770"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8771"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// MessageControlID
		/// </summary>
		public string MessageControlID
		{
			get
			{
				return _messageControlID;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8756"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8757"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// MessageType
		/// </summary>
		public string MessageType
		{
			get
			{
				return MESSAGE_TYPE;
			}

		}
		
		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8762"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8763"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// MSH
		/// </summary>
		public string MSH
		{
			get
			{
				return _msh;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8760"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8761"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// MSA
		/// </summary>
		public string MSA
		{
			get
			{
				return _msa;
			}
		}

		///<Developers>
		///	<Developer>saic</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/23/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8764"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8765"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ERR
		/// </summary>
		public string ERR
		{
			get
			{
				return _err;
			}
		}

		#endregion
	}
}
